# FocusOps Quick Add - Chrome Extension

A browser extension that lets you quickly add tasks to FocusOps from anywhere using a global keyboard shortcut, and track time directly from your browser.

## Requirements

- **FocusOps Account**: You must be logged into FocusOps to use the extension. If you're not logged in, the extension will prompt you to open the app and sign in.

## Features

- **Works Offline**: The extension works even when FocusOps isn't open - tasks sync directly to your account
- **Global Keyboard Shortcut**: `Ctrl+Shift+Space` (or `Cmd+Shift+Space` on Mac) opens the quick add popup from any webpage
- **Task Search**: Type to search existing tasks or create new ones
- **Selection to Task**: `Ctrl+Shift+T` creates a task from selected text
- **Time Tracking**: Start/stop time tracking from anywhere without opening the app
- **NLP Task Parsing**: Same natural language parsing as the main app
  - Time estimates: `2h`, `30m`, `1h30m`
  - Priority: `#high`, `#urgent`, `!!`, `#low`
  - Due dates: `tomorrow`, `next week`, `friday`
  - Project/Client: `for Acme Corp`, `@ClientName`
- **Right-Click Context Menu**: Add selected text, links, or pages directly to FocusOps
- **Ctrl+Double-Click**: Quick add selected text on any webpage

## How the Offline Mode Works

The extension maintains a connection to FocusOps even when the app isn't open:

1. **First Login**: Open FocusOps in a tab and log in. The extension automatically captures your auth tokens.
2. **Token Caching**: Auth tokens are securely stored in the extension for up to 7 days.
3. **Direct API Access**: When FocusOps isn't open, the extension communicates directly with the server.
4. **Task Cache**: Your task list is cached locally for fast searching, even offline.
5. **Auto Sync**: When you open FocusOps again, the extension refreshes tokens and caches.

## Installation

### From Source (Development)

1. Open Chrome and navigate to `chrome://extensions/`
2. Enable "Developer mode" in the top right
3. Click "Load unpacked"
4. Select the `browser-extension` folder from this repository

### Configuring the App URL

1. Click the FocusOps extension icon
2. Click the ⚙️ Settings button
3. Enter your FocusOps URL (default: `https://app.focusops.net`)
4. The URL is saved automatically

### Customizing Keyboard Shortcuts

1. Go to `chrome://extensions/shortcuts`
2. Find "FocusOps Quick Add"
3. Click the pencil icon to change the shortcuts

## Usage

### Quick Add Popup

1. Press `Ctrl+Shift+Space` from anywhere
2. Type your task using natural language:
   ```
   Call John 30m tomorrow #high for Acme Corp
   ```
3. As you type, existing tasks matching your text will appear
4. Press Enter to create the task (or select an existing one)

### Searching Existing Tasks

1. Open the extension (`Ctrl+Shift+Space`)
2. Start typing - matching tasks appear in a dropdown
3. Use ↑/↓ arrow keys to navigate
4. Press Enter to select an existing task (starts tracking)
5. Or click "Create new task" to add a new one

### From Selected Text

1. Select text on any webpage
2. Press `Ctrl+Shift+T` OR right-click → "Add to FocusOps"
3. The popup opens with the selected text pre-filled
4. Edit if needed, then press Enter

### Time Tracking

1. Open the extension popup (`Ctrl+Shift+Space`)
2. Either:
   - Type a new task description
   - Or search and select an existing task
3. Click **▶ Start Tracking** to begin
4. The timer runs even when the popup is closed
5. Open the popup again and click **⏹ Stop** to end tracking
6. Time is automatically synced to FocusOps

**Note**: If FocusOps isn't open when you stop tracking, the time log is queued and synced when you next open the app.

### Context Menu

Right-click on:
- **Selected text**: Creates task from selection
- **A link**: Creates task with the link URL
- **The page**: Creates task with the page title and URL

## How It Works

1. The extension opens a popup with the quick add interface
2. Your task text is parsed using NLP to extract:
   - Clean title
   - Priority level
   - Time estimate
   - Due date
   - Project/client references
3. When you submit, it either:
   - Creates the task directly via the Supabase API (if FocusOps isn't open)
   - Sends the task to an existing FocusOps tab (for immediate UI update)

## Files

```
browser-extension/
├── manifest.json      # Extension configuration
├── popup.html         # Quick add popup UI
├── popup.js           # Popup logic, NLP parsing, and Supabase API
├── background.js      # Service worker for shortcuts/context menus
├── content.js         # Content script for page integration
└── icons/             # Extension icons
```

## Permissions

- `storage`: Save settings and cache auth tokens
- `activeTab`: Get selected text from the current tab
- `scripting`: Execute scripts to capture text selection
- Host permissions for FocusOps URLs and Supabase API

## Troubleshooting

### "Login Required" appears even though I'm logged in?
- Open FocusOps in a new tab and ensure you're logged in
- Close and reopen the extension popup
- Click "I'm already logged in - continue anyway" if the issue persists

### Shortcut not working?
- Check `chrome://extensions/shortcuts` to ensure shortcuts are configured
- Some websites may override keyboard shortcuts

### Can't find my tasks?
- Tasks are cached when you first open the extension with the app open
- Open FocusOps once to refresh the task cache
- Only non-completed tasks are shown in search

### Extension not loading?
- Check the Chrome console for errors
- Try reloading the extension in `chrome://extensions/`
